package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAssistantAssociationResponse(
    assistantAssociation: Optional[
      zio.aws.wisdom.model.AssistantAssociationData
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationResponse = {
    import CreateAssistantAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationResponse
      .builder()
      .optionallyWith(assistantAssociation.map(value => value.buildAwsValue()))(
        _.assistantAssociation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.CreateAssistantAssociationResponse.ReadOnly =
    zio.aws.wisdom.model.CreateAssistantAssociationResponse
      .wrap(buildAwsValue())
}
object CreateAssistantAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.CreateAssistantAssociationResponse =
      zio.aws.wisdom.model.CreateAssistantAssociationResponse(
        assistantAssociation.map(value => value.asEditable)
      )
    def assistantAssociation
        : Optional[zio.aws.wisdom.model.AssistantAssociationData.ReadOnly]
    def getAssistantAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.AssistantAssociationData.ReadOnly
    ] = AwsError.unwrapOptionField("assistantAssociation", assistantAssociation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationResponse
  ) extends zio.aws.wisdom.model.CreateAssistantAssociationResponse.ReadOnly {
    override val assistantAssociation
        : Optional[zio.aws.wisdom.model.AssistantAssociationData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assistantAssociation())
        .map(value => zio.aws.wisdom.model.AssistantAssociationData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationResponse
  ): zio.aws.wisdom.model.CreateAssistantAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
