package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait AssistantType {
  def unwrap: software.amazon.awssdk.services.wisdom.model.AssistantType
}
object AssistantType {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.AssistantType
  ): zio.aws.wisdom.model.AssistantType = value match {
    case software.amazon.awssdk.services.wisdom.model.AssistantType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.AssistantType.AGENT =>
      val r = AGENT
      r
  }
  case object unknownToSdkVersion extends zio.aws.wisdom.model.AssistantType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.AssistantType =
      software.amazon.awssdk.services.wisdom.model.AssistantType.UNKNOWN_TO_SDK_VERSION
  }
  case object AGENT extends zio.aws.wisdom.model.AssistantType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.AssistantType =
      software.amazon.awssdk.services.wisdom.model.AssistantType.AGENT
  }
}
