package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{
  QueryText,
  NextToken,
  MaxResults,
  UuidOrArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class QueryAssistantRequest(
    assistantId: UuidOrArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    queryText: QueryText
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.QueryAssistantRequest = {
    import QueryAssistantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.QueryAssistantRequest
      .builder()
      .assistantId(UuidOrArn.unwrap(assistantId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .queryText(QueryText.unwrap(queryText): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.QueryAssistantRequest.ReadOnly =
    zio.aws.wisdom.model.QueryAssistantRequest.wrap(buildAwsValue())
}
object QueryAssistantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.QueryAssistantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.QueryAssistantRequest =
      zio.aws.wisdom.model.QueryAssistantRequest(
        assistantId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        queryText
      )
    def assistantId: UuidOrArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def queryText: QueryText
    def getAssistantId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(assistantId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getQueryText: ZIO[Any, Nothing, QueryText] = ZIO.succeed(queryText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.QueryAssistantRequest
  ) extends zio.aws.wisdom.model.QueryAssistantRequest.ReadOnly {
    override val assistantId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.wisdom.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NextToken(value))
    override val queryText: QueryText =
      zio.aws.wisdom.model.primitives.QueryText(impl.queryText())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.QueryAssistantRequest
  ): zio.aws.wisdom.model.QueryAssistantRequest.ReadOnly = new Wrapper(impl)
}
