package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RecommendationTriggerData(
    query: Optional[zio.aws.wisdom.model.QueryRecommendationTriggerData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.RecommendationTriggerData = {
    import RecommendationTriggerData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.RecommendationTriggerData
      .builder()
      .optionallyWith(query.map(value => value.buildAwsValue()))(_.query)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.RecommendationTriggerData.ReadOnly =
    zio.aws.wisdom.model.RecommendationTriggerData.wrap(buildAwsValue())
}
object RecommendationTriggerData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.RecommendationTriggerData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.RecommendationTriggerData =
      zio.aws.wisdom.model
        .RecommendationTriggerData(query.map(value => value.asEditable))
    def query
        : Optional[zio.aws.wisdom.model.QueryRecommendationTriggerData.ReadOnly]
    def getQuery: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.QueryRecommendationTriggerData.ReadOnly
    ] = AwsError.unwrapOptionField("query", query)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.RecommendationTriggerData
  ) extends zio.aws.wisdom.model.RecommendationTriggerData.ReadOnly {
    override val query: Optional[
      zio.aws.wisdom.model.QueryRecommendationTriggerData.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.query())
      .map(value =>
        zio.aws.wisdom.model.QueryRecommendationTriggerData.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.RecommendationTriggerData
  ): zio.aws.wisdom.model.RecommendationTriggerData.ReadOnly = new Wrapper(impl)
}
