package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.UuidOrArn
import scala.jdk.CollectionConverters.*
final case class GetSessionRequest(
    assistantId: UuidOrArn,
    sessionId: UuidOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetSessionRequest = {
    import GetSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetSessionRequest
      .builder()
      .assistantId(UuidOrArn.unwrap(assistantId): java.lang.String)
      .sessionId(UuidOrArn.unwrap(sessionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetSessionRequest.ReadOnly =
    zio.aws.wisdom.model.GetSessionRequest.wrap(buildAwsValue())
}
object GetSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetSessionRequest =
      zio.aws.wisdom.model.GetSessionRequest(assistantId, sessionId)
    def assistantId: UuidOrArn
    def sessionId: UuidOrArn
    def getAssistantId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(assistantId)
    def getSessionId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetSessionRequest
  ) extends zio.aws.wisdom.model.GetSessionRequest.ReadOnly {
    override val assistantId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantId())
    override val sessionId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetSessionRequest
  ): zio.aws.wisdom.model.GetSessionRequest.ReadOnly = new Wrapper(impl)
}
