package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class Filter(
    field: zio.aws.wisdom.model.FilterField,
    operator: zio.aws.wisdom.model.FilterOperator,
    value: NonEmptyString
) {
  def buildAwsValue(): software.amazon.awssdk.services.wisdom.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.Filter
      .builder()
      .field(field.unwrap)
      .operator(operator.unwrap)
      .value(NonEmptyString.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.Filter.ReadOnly =
    zio.aws.wisdom.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wisdom.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.Filter =
      zio.aws.wisdom.model.Filter(field, operator, value)
    def field: zio.aws.wisdom.model.FilterField
    def operator: zio.aws.wisdom.model.FilterOperator
    def value: NonEmptyString
    def getField: ZIO[Any, Nothing, zio.aws.wisdom.model.FilterField] =
      ZIO.succeed(field)
    def getOperator: ZIO[Any, Nothing, zio.aws.wisdom.model.FilterOperator] =
      ZIO.succeed(operator)
    def getValue: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.Filter
  ) extends zio.aws.wisdom.model.Filter.ReadOnly {
    override val field: zio.aws.wisdom.model.FilterField =
      zio.aws.wisdom.model.FilterField.wrap(impl.field())
    override val operator: zio.aws.wisdom.model.FilterOperator =
      zio.aws.wisdom.model.FilterOperator.wrap(impl.operator())
    override val value: NonEmptyString =
      zio.aws.wisdom.model.primitives.NonEmptyString(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.Filter
  ): zio.aws.wisdom.model.Filter.ReadOnly = new Wrapper(impl)
}
