package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.UuidOrArn
import scala.jdk.CollectionConverters.*
final case class DeleteAssistantRequest(assistantId: UuidOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.DeleteAssistantRequest = {
    import DeleteAssistantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.DeleteAssistantRequest
      .builder()
      .assistantId(UuidOrArn.unwrap(assistantId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.DeleteAssistantRequest.ReadOnly =
    zio.aws.wisdom.model.DeleteAssistantRequest.wrap(buildAwsValue())
}
object DeleteAssistantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.DeleteAssistantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.DeleteAssistantRequest =
      zio.aws.wisdom.model.DeleteAssistantRequest(assistantId)
    def assistantId: UuidOrArn
    def getAssistantId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(assistantId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.DeleteAssistantRequest
  ) extends zio.aws.wisdom.model.DeleteAssistantRequest.ReadOnly {
    override val assistantId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.DeleteAssistantRequest
  ): zio.aws.wisdom.model.DeleteAssistantRequest.ReadOnly = new Wrapper(impl)
}
