package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.Uri
import scala.jdk.CollectionConverters.*
final case class RenderingConfiguration(
    templateUri: Optional[Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.RenderingConfiguration = {
    import RenderingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.RenderingConfiguration
      .builder()
      .optionallyWith(
        templateUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.templateUri)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.RenderingConfiguration.ReadOnly =
    zio.aws.wisdom.model.RenderingConfiguration.wrap(buildAwsValue())
}
object RenderingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.RenderingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.RenderingConfiguration =
      zio.aws.wisdom.model
        .RenderingConfiguration(templateUri.map(value => value))
    def templateUri: Optional[Uri]
    def getTemplateUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("templateUri", templateUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.RenderingConfiguration
  ) extends zio.aws.wisdom.model.RenderingConfiguration.ReadOnly {
    override val templateUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.templateUri())
      .map(value => zio.aws.wisdom.model.primitives.Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.RenderingConfiguration
  ): zio.aws.wisdom.model.RenderingConfiguration.ReadOnly = new Wrapper(impl)
}
