package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait FilterOperator {
  def unwrap: software.amazon.awssdk.services.wisdom.model.FilterOperator
}
object FilterOperator {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.FilterOperator
  ): zio.aws.wisdom.model.FilterOperator = value match {
    case software.amazon.awssdk.services.wisdom.model.FilterOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.FilterOperator.EQUALS =>
      val r = EQUALS
      r
  }
  case object unknownToSdkVersion extends zio.aws.wisdom.model.FilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.FilterOperator =
      software.amazon.awssdk.services.wisdom.model.FilterOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUALS extends zio.aws.wisdom.model.FilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.FilterOperator =
      software.amazon.awssdk.services.wisdom.model.FilterOperator.EQUALS
  }
}
