package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssistantAssociationOutputData(
    knowledgeBaseAssociation: Optional[
      zio.aws.wisdom.model.KnowledgeBaseAssociationData
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.AssistantAssociationOutputData = {
    import AssistantAssociationOutputData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.AssistantAssociationOutputData
      .builder()
      .optionallyWith(
        knowledgeBaseAssociation.map(value => value.buildAwsValue())
      )(_.knowledgeBaseAssociation)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.AssistantAssociationOutputData.ReadOnly =
    zio.aws.wisdom.model.AssistantAssociationOutputData.wrap(buildAwsValue())
}
object AssistantAssociationOutputData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.AssistantAssociationOutputData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.AssistantAssociationOutputData =
      zio.aws.wisdom.model.AssistantAssociationOutputData(
        knowledgeBaseAssociation.map(value => value.asEditable)
      )
    def knowledgeBaseAssociation
        : Optional[zio.aws.wisdom.model.KnowledgeBaseAssociationData.ReadOnly]
    def getKnowledgeBaseAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.KnowledgeBaseAssociationData.ReadOnly
    ] = AwsError.unwrapOptionField(
      "knowledgeBaseAssociation",
      knowledgeBaseAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.AssistantAssociationOutputData
  ) extends zio.aws.wisdom.model.AssistantAssociationOutputData.ReadOnly {
    override val knowledgeBaseAssociation
        : Optional[zio.aws.wisdom.model.KnowledgeBaseAssociationData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.knowledgeBaseAssociation())
        .map(value =>
          zio.aws.wisdom.model.KnowledgeBaseAssociationData.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.AssistantAssociationOutputData
  ): zio.aws.wisdom.model.AssistantAssociationOutputData.ReadOnly = new Wrapper(
    impl
  )
}
