package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class ServerSideEncryptionConfiguration(
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ServerSideEncryptionConfiguration = {
    import ServerSideEncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ServerSideEncryptionConfiguration
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly =
    zio.aws.wisdom.model.ServerSideEncryptionConfiguration.wrap(buildAwsValue())
}
object ServerSideEncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ServerSideEncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ServerSideEncryptionConfiguration =
      zio.aws.wisdom.model
        .ServerSideEncryptionConfiguration(kmsKeyId.map(value => value))
    def kmsKeyId: Optional[NonEmptyString]
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ServerSideEncryptionConfiguration
  ) extends zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly {
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ServerSideEncryptionConfiguration
  ): zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
