package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{NextToken, MaxResults, UuidOrArn}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchSessionsRequest(
    assistantId: UuidOrArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    searchExpression: zio.aws.wisdom.model.SearchExpression
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.SearchSessionsRequest = {
    import SearchSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.SearchSessionsRequest
      .builder()
      .assistantId(UuidOrArn.unwrap(assistantId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .searchExpression(searchExpression.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.SearchSessionsRequest.ReadOnly =
    zio.aws.wisdom.model.SearchSessionsRequest.wrap(buildAwsValue())
}
object SearchSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.SearchSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.SearchSessionsRequest =
      zio.aws.wisdom.model.SearchSessionsRequest(
        assistantId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        searchExpression.asEditable
      )
    def assistantId: UuidOrArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def searchExpression: zio.aws.wisdom.model.SearchExpression.ReadOnly
    def getAssistantId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(assistantId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSearchExpression
        : ZIO[Any, Nothing, zio.aws.wisdom.model.SearchExpression.ReadOnly] =
      ZIO.succeed(searchExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.SearchSessionsRequest
  ) extends zio.aws.wisdom.model.SearchSessionsRequest.ReadOnly {
    override val assistantId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.wisdom.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NextToken(value))
    override val searchExpression
        : zio.aws.wisdom.model.SearchExpression.ReadOnly =
      zio.aws.wisdom.model.SearchExpression.wrap(impl.searchExpression())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.SearchSessionsRequest
  ): zio.aws.wisdom.model.SearchSessionsRequest.ReadOnly = new Wrapper(impl)
}
