package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait RecommendationTriggerType {
  def unwrap
      : software.amazon.awssdk.services.wisdom.model.RecommendationTriggerType
}
object RecommendationTriggerType {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.RecommendationTriggerType
  ): zio.aws.wisdom.model.RecommendationTriggerType = value match {
    case software.amazon.awssdk.services.wisdom.model.RecommendationTriggerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.RecommendationTriggerType.QUERY =>
      val r = QUERY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wisdom.model.RecommendationTriggerType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.RecommendationTriggerType =
      software.amazon.awssdk.services.wisdom.model.RecommendationTriggerType.UNKNOWN_TO_SDK_VERSION
  }
  case object QUERY extends zio.aws.wisdom.model.RecommendationTriggerType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.RecommendationTriggerType =
      software.amazon.awssdk.services.wisdom.model.RecommendationTriggerType.QUERY
  }
}
