package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.NotifyRecommendationsReceivedErrorMessage
import scala.jdk.CollectionConverters.*
final case class NotifyRecommendationsReceivedError(
    message: Optional[NotifyRecommendationsReceivedErrorMessage] =
      Optional.Absent,
    recommendationId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedError = {
    import NotifyRecommendationsReceivedError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedError
      .builder()
      .optionallyWith(
        message.map(value =>
          NotifyRecommendationsReceivedErrorMessage.unwrap(
            value
          ): java.lang.String
        )
      )(_.message)
      .optionallyWith(recommendationId.map(value => value: java.lang.String))(
        _.recommendationId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.NotifyRecommendationsReceivedError.ReadOnly =
    zio.aws.wisdom.model.NotifyRecommendationsReceivedError
      .wrap(buildAwsValue())
}
object NotifyRecommendationsReceivedError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.NotifyRecommendationsReceivedError =
      zio.aws.wisdom.model.NotifyRecommendationsReceivedError(
        message.map(value => value),
        recommendationId.map(value => value)
      )
    def message: Optional[NotifyRecommendationsReceivedErrorMessage]
    def recommendationId: Optional[String]
    def getMessage
        : ZIO[Any, AwsError, NotifyRecommendationsReceivedErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getRecommendationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("recommendationId", recommendationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedError
  ) extends zio.aws.wisdom.model.NotifyRecommendationsReceivedError.ReadOnly {
    override val message: Optional[NotifyRecommendationsReceivedErrorMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value =>
          zio.aws.wisdom.model.primitives
            .NotifyRecommendationsReceivedErrorMessage(value)
        )
    override val recommendationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedError
  ): zio.aws.wisdom.model.NotifyRecommendationsReceivedError.ReadOnly =
    new Wrapper(impl)
}
