package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{
  TagValue,
  Description,
  Name,
  NonEmptyString,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateKnowledgeBaseRequest(
    clientToken: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    knowledgeBaseType: zio.aws.wisdom.model.KnowledgeBaseType,
    name: Name,
    renderingConfiguration: Optional[
      zio.aws.wisdom.model.RenderingConfiguration
    ] = Optional.Absent,
    serverSideEncryptionConfiguration: Optional[
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration
    ] = Optional.Absent,
    sourceConfiguration: Optional[zio.aws.wisdom.model.SourceConfiguration] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseRequest = {
    import CreateKnowledgeBaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .knowledgeBaseType(knowledgeBaseType.unwrap)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        renderingConfiguration.map(value => value.buildAwsValue())
      )(_.renderingConfiguration)
      .optionallyWith(
        serverSideEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.serverSideEncryptionConfiguration)
      .optionallyWith(sourceConfiguration.map(value => value.buildAwsValue()))(
        _.sourceConfiguration
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.CreateKnowledgeBaseRequest.ReadOnly =
    zio.aws.wisdom.model.CreateKnowledgeBaseRequest.wrap(buildAwsValue())
}
object CreateKnowledgeBaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.CreateKnowledgeBaseRequest =
      zio.aws.wisdom.model.CreateKnowledgeBaseRequest(
        clientToken.map(value => value),
        description.map(value => value),
        knowledgeBaseType,
        name,
        renderingConfiguration.map(value => value.asEditable),
        serverSideEncryptionConfiguration.map(value => value.asEditable),
        sourceConfiguration.map(value => value.asEditable),
        tags.map(value => value)
      )
    def clientToken: Optional[NonEmptyString]
    def description: Optional[Description]
    def knowledgeBaseType: zio.aws.wisdom.model.KnowledgeBaseType
    def name: Name
    def renderingConfiguration
        : Optional[zio.aws.wisdom.model.RenderingConfiguration.ReadOnly]
    def serverSideEncryptionConfiguration: Optional[
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly
    ]
    def sourceConfiguration
        : Optional[zio.aws.wisdom.model.SourceConfiguration.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getKnowledgeBaseType
        : ZIO[Any, Nothing, zio.aws.wisdom.model.KnowledgeBaseType] =
      ZIO.succeed(knowledgeBaseType)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getRenderingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.RenderingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "renderingConfiguration",
      renderingConfiguration
    )
    def getServerSideEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverSideEncryptionConfiguration",
      serverSideEncryptionConfiguration
    )
    def getSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.SourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sourceConfiguration", sourceConfiguration)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseRequest
  ) extends zio.aws.wisdom.model.CreateKnowledgeBaseRequest.ReadOnly {
    override val clientToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.wisdom.model.primitives.Description(value))
    override val knowledgeBaseType: zio.aws.wisdom.model.KnowledgeBaseType =
      zio.aws.wisdom.model.KnowledgeBaseType.wrap(impl.knowledgeBaseType())
    override val name: Name = zio.aws.wisdom.model.primitives.Name(impl.name())
    override val renderingConfiguration
        : Optional[zio.aws.wisdom.model.RenderingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renderingConfiguration())
        .map(value => zio.aws.wisdom.model.RenderingConfiguration.wrap(value))
    override val serverSideEncryptionConfiguration: Optional[
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideEncryptionConfiguration())
      .map(value =>
        zio.aws.wisdom.model.ServerSideEncryptionConfiguration.wrap(value)
      )
    override val sourceConfiguration
        : Optional[zio.aws.wisdom.model.SourceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceConfiguration())
        .map(value => zio.aws.wisdom.model.SourceConfiguration.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseRequest
  ): zio.aws.wisdom.model.CreateKnowledgeBaseRequest.ReadOnly = new Wrapper(
    impl
  )
}
