package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait RecommendationSourceType {
  def unwrap
      : software.amazon.awssdk.services.wisdom.model.RecommendationSourceType
}
object RecommendationSourceType {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.RecommendationSourceType
  ): zio.aws.wisdom.model.RecommendationSourceType = value match {
    case software.amazon.awssdk.services.wisdom.model.RecommendationSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.RecommendationSourceType.ISSUE_DETECTION =>
      val r = ISSUE_DETECTION
      r
    case software.amazon.awssdk.services.wisdom.model.RecommendationSourceType.RULE_EVALUATION =>
      val r = RULE_EVALUATION
      r
    case software.amazon.awssdk.services.wisdom.model.RecommendationSourceType.OTHER =>
      val r = OTHER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wisdom.model.RecommendationSourceType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.RecommendationSourceType =
      software.amazon.awssdk.services.wisdom.model.RecommendationSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ISSUE_DETECTION
      extends zio.aws.wisdom.model.RecommendationSourceType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.RecommendationSourceType =
      software.amazon.awssdk.services.wisdom.model.RecommendationSourceType.ISSUE_DETECTION
  }
  case object RULE_EVALUATION
      extends zio.aws.wisdom.model.RecommendationSourceType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.RecommendationSourceType =
      software.amazon.awssdk.services.wisdom.model.RecommendationSourceType.RULE_EVALUATION
  }
  case object OTHER extends zio.aws.wisdom.model.RecommendationSourceType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.RecommendationSourceType =
      software.amazon.awssdk.services.wisdom.model.RecommendationSourceType.OTHER
  }
}
