package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.QueryText
import scala.jdk.CollectionConverters.*
final case class QueryRecommendationTriggerData(
    text: Optional[QueryText] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.QueryRecommendationTriggerData = {
    import QueryRecommendationTriggerData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.QueryRecommendationTriggerData
      .builder()
      .optionallyWith(
        text.map(value => QueryText.unwrap(value): java.lang.String)
      )(_.text)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.QueryRecommendationTriggerData.ReadOnly =
    zio.aws.wisdom.model.QueryRecommendationTriggerData.wrap(buildAwsValue())
}
object QueryRecommendationTriggerData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.QueryRecommendationTriggerData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.QueryRecommendationTriggerData =
      zio.aws.wisdom.model
        .QueryRecommendationTriggerData(text.map(value => value))
    def text: Optional[QueryText]
    def getText: ZIO[Any, AwsError, QueryText] =
      AwsError.unwrapOptionField("text", text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.QueryRecommendationTriggerData
  ) extends zio.aws.wisdom.model.QueryRecommendationTriggerData.ReadOnly {
    override val text: Optional[QueryText] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => zio.aws.wisdom.model.primitives.QueryText(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.QueryRecommendationTriggerData
  ): zio.aws.wisdom.model.QueryRecommendationTriggerData.ReadOnly = new Wrapper(
    impl
  )
}
