package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{NonEmptyString, MaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListKnowledgeBasesRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesRequest = {
    import ListKnowledgeBasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ListKnowledgeBasesRequest.ReadOnly =
    zio.aws.wisdom.model.ListKnowledgeBasesRequest.wrap(buildAwsValue())
}
object ListKnowledgeBasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ListKnowledgeBasesRequest =
      zio.aws.wisdom.model.ListKnowledgeBasesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NonEmptyString]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesRequest
  ) extends zio.aws.wisdom.model.ListKnowledgeBasesRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.wisdom.model.primitives.MaxResults(value))
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesRequest
  ): zio.aws.wisdom.model.ListKnowledgeBasesRequest.ReadOnly = new Wrapper(impl)
}
