package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.HighlightOffset
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Highlight(
    beginOffsetInclusive: Optional[HighlightOffset] = Optional.Absent,
    endOffsetExclusive: Optional[HighlightOffset] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.Highlight = {
    import Highlight.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.Highlight
      .builder()
      .optionallyWith(
        beginOffsetInclusive.map(value =>
          HighlightOffset.unwrap(value): Integer
        )
      )(_.beginOffsetInclusive)
      .optionallyWith(
        endOffsetExclusive.map(value => HighlightOffset.unwrap(value): Integer)
      )(_.endOffsetExclusive)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.Highlight.ReadOnly =
    zio.aws.wisdom.model.Highlight.wrap(buildAwsValue())
}
object Highlight {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wisdom.model.Highlight] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.Highlight =
      zio.aws.wisdom.model.Highlight(
        beginOffsetInclusive.map(value => value),
        endOffsetExclusive.map(value => value)
      )
    def beginOffsetInclusive: Optional[HighlightOffset]
    def endOffsetExclusive: Optional[HighlightOffset]
    def getBeginOffsetInclusive: ZIO[Any, AwsError, HighlightOffset] =
      AwsError.unwrapOptionField("beginOffsetInclusive", beginOffsetInclusive)
    def getEndOffsetExclusive: ZIO[Any, AwsError, HighlightOffset] =
      AwsError.unwrapOptionField("endOffsetExclusive", endOffsetExclusive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.Highlight
  ) extends zio.aws.wisdom.model.Highlight.ReadOnly {
    override val beginOffsetInclusive: Optional[HighlightOffset] =
      zio.aws.core.internal
        .optionalFromNullable(impl.beginOffsetInclusive())
        .map(value => zio.aws.wisdom.model.primitives.HighlightOffset(value))
    override val endOffsetExclusive: Optional[HighlightOffset] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endOffsetExclusive())
        .map(value => zio.aws.wisdom.model.primitives.HighlightOffset(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.Highlight
  ): zio.aws.wisdom.model.Highlight.ReadOnly = new Wrapper(impl)
}
