package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetKnowledgeBaseResponse(
    knowledgeBase: Optional[zio.aws.wisdom.model.KnowledgeBaseData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseResponse = {
    import GetKnowledgeBaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseResponse
      .builder()
      .optionallyWith(knowledgeBase.map(value => value.buildAwsValue()))(
        _.knowledgeBase
      )
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetKnowledgeBaseResponse.ReadOnly =
    zio.aws.wisdom.model.GetKnowledgeBaseResponse.wrap(buildAwsValue())
}
object GetKnowledgeBaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetKnowledgeBaseResponse =
      zio.aws.wisdom.model
        .GetKnowledgeBaseResponse(knowledgeBase.map(value => value.asEditable))
    def knowledgeBase: Optional[zio.aws.wisdom.model.KnowledgeBaseData.ReadOnly]
    def getKnowledgeBase
        : ZIO[Any, AwsError, zio.aws.wisdom.model.KnowledgeBaseData.ReadOnly] =
      AwsError.unwrapOptionField("knowledgeBase", knowledgeBase)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseResponse
  ) extends zio.aws.wisdom.model.GetKnowledgeBaseResponse.ReadOnly {
    override val knowledgeBase
        : Optional[zio.aws.wisdom.model.KnowledgeBaseData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.knowledgeBase())
        .map(value => zio.aws.wisdom.model.KnowledgeBaseData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseResponse
  ): zio.aws.wisdom.model.GetKnowledgeBaseResponse.ReadOnly = new Wrapper(impl)
}
