package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait FilterField {
  def unwrap: software.amazon.awssdk.services.wisdom.model.FilterField
}
object FilterField {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.FilterField
  ): zio.aws.wisdom.model.FilterField = value match {
    case software.amazon.awssdk.services.wisdom.model.FilterField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.FilterField.NAME =>
      val r = NAME
      r
  }
  case object unknownToSdkVersion extends zio.aws.wisdom.model.FilterField {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.FilterField =
      software.amazon.awssdk.services.wisdom.model.FilterField.UNKNOWN_TO_SDK_VERSION
  }
  case object NAME extends zio.aws.wisdom.model.FilterField {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.FilterField =
      software.amazon.awssdk.services.wisdom.model.FilterField.NAME
  }
}
