package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.{Uri, UuidOrArn}
import scala.jdk.CollectionConverters.*
final case class UpdateKnowledgeBaseTemplateUriRequest(
    knowledgeBaseId: UuidOrArn,
    templateUri: Uri
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest = {
    import UpdateKnowledgeBaseTemplateUriRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest
      .builder()
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .templateUri(Uri.unwrap(templateUri): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest.ReadOnly =
    zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest
      .wrap(buildAwsValue())
}
object UpdateKnowledgeBaseTemplateUriRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest =
      zio.aws.wisdom.model
        .UpdateKnowledgeBaseTemplateUriRequest(knowledgeBaseId, templateUri)
    def knowledgeBaseId: UuidOrArn
    def templateUri: Uri
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
    def getTemplateUri: ZIO[Any, Nothing, Uri] = ZIO.succeed(templateUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest
  ) extends zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest.ReadOnly {
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
    override val templateUri: Uri =
      zio.aws.wisdom.model.primitives.Uri(impl.templateUri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest
  ): zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest.ReadOnly =
    new Wrapper(impl)
}
