package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.Uuid
import scala.jdk.CollectionConverters.*
final case class RecommendationTrigger(
    data: zio.aws.wisdom.model.RecommendationTriggerData,
    id: Uuid,
    recommendationIds: Iterable[String],
    source: zio.aws.wisdom.model.RecommendationSourceType,
    `type`: zio.aws.wisdom.model.RecommendationTriggerType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.RecommendationTrigger = {
    import RecommendationTrigger.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.RecommendationTrigger
      .builder()
      .data(data.buildAwsValue())
      .id(Uuid.unwrap(id): java.lang.String)
      .recommendationIds(recommendationIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .source(source.unwrap)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.RecommendationTrigger.ReadOnly =
    zio.aws.wisdom.model.RecommendationTrigger.wrap(buildAwsValue())
}
object RecommendationTrigger {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.RecommendationTrigger
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.RecommendationTrigger =
      zio.aws.wisdom.model.RecommendationTrigger(
        data.asEditable,
        id,
        recommendationIds,
        source,
        `type`
      )
    def data: zio.aws.wisdom.model.RecommendationTriggerData.ReadOnly
    def id: Uuid
    def recommendationIds: List[String]
    def source: zio.aws.wisdom.model.RecommendationSourceType
    def `type`: zio.aws.wisdom.model.RecommendationTriggerType
    def getData: ZIO[
      Any,
      Nothing,
      zio.aws.wisdom.model.RecommendationTriggerData.ReadOnly
    ] = ZIO.succeed(data)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getRecommendationIds: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(recommendationIds)
    def getSource
        : ZIO[Any, Nothing, zio.aws.wisdom.model.RecommendationSourceType] =
      ZIO.succeed(source)
    def getType
        : ZIO[Any, Nothing, zio.aws.wisdom.model.RecommendationTriggerType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.RecommendationTrigger
  ) extends zio.aws.wisdom.model.RecommendationTrigger.ReadOnly {
    override val data: zio.aws.wisdom.model.RecommendationTriggerData.ReadOnly =
      zio.aws.wisdom.model.RecommendationTriggerData.wrap(impl.data())
    override val id: Uuid = zio.aws.wisdom.model.primitives.Uuid(impl.id())
    override val recommendationIds: List[String] = impl
      .recommendationIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val source: zio.aws.wisdom.model.RecommendationSourceType =
      zio.aws.wisdom.model.RecommendationSourceType.wrap(impl.source())
    override val `type`: zio.aws.wisdom.model.RecommendationTriggerType =
      zio.aws.wisdom.model.RecommendationTriggerType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.RecommendationTrigger
  ): zio.aws.wisdom.model.RecommendationTrigger.ReadOnly = new Wrapper(impl)
}
