package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class ListKnowledgeBasesResponse(
    knowledgeBaseSummaries: Iterable[zio.aws.wisdom.model.KnowledgeBaseSummary],
    nextToken: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesResponse = {
    import ListKnowledgeBasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesResponse
      .builder()
      .knowledgeBaseSummaries(knowledgeBaseSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ListKnowledgeBasesResponse.ReadOnly =
    zio.aws.wisdom.model.ListKnowledgeBasesResponse.wrap(buildAwsValue())
}
object ListKnowledgeBasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ListKnowledgeBasesResponse =
      zio.aws.wisdom.model.ListKnowledgeBasesResponse(
        knowledgeBaseSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def knowledgeBaseSummaries
        : List[zio.aws.wisdom.model.KnowledgeBaseSummary.ReadOnly]
    def nextToken: Optional[NonEmptyString]
    def getKnowledgeBaseSummaries: ZIO[Any, Nothing, List[
      zio.aws.wisdom.model.KnowledgeBaseSummary.ReadOnly
    ]] = ZIO.succeed(knowledgeBaseSummaries)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesResponse
  ) extends zio.aws.wisdom.model.ListKnowledgeBasesResponse.ReadOnly {
    override val knowledgeBaseSummaries
        : List[zio.aws.wisdom.model.KnowledgeBaseSummary.ReadOnly] = impl
      .knowledgeBaseSummaries()
      .asScala
      .map { item =>
        zio.aws.wisdom.model.KnowledgeBaseSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesResponse
  ): zio.aws.wisdom.model.ListKnowledgeBasesResponse.ReadOnly = new Wrapper(
    impl
  )
}
