package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetContentSummaryResponse(
    contentSummary: Optional[zio.aws.wisdom.model.ContentSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetContentSummaryResponse = {
    import GetContentSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetContentSummaryResponse
      .builder()
      .optionallyWith(contentSummary.map(value => value.buildAwsValue()))(
        _.contentSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetContentSummaryResponse.ReadOnly =
    zio.aws.wisdom.model.GetContentSummaryResponse.wrap(buildAwsValue())
}
object GetContentSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetContentSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetContentSummaryResponse =
      zio.aws.wisdom.model.GetContentSummaryResponse(
        contentSummary.map(value => value.asEditable)
      )
    def contentSummary: Optional[zio.aws.wisdom.model.ContentSummary.ReadOnly]
    def getContentSummary
        : ZIO[Any, AwsError, zio.aws.wisdom.model.ContentSummary.ReadOnly] =
      AwsError.unwrapOptionField("contentSummary", contentSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetContentSummaryResponse
  ) extends zio.aws.wisdom.model.GetContentSummaryResponse.ReadOnly {
    override val contentSummary
        : Optional[zio.aws.wisdom.model.ContentSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentSummary())
        .map(value => zio.aws.wisdom.model.ContentSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetContentSummaryResponse
  ): zio.aws.wisdom.model.GetContentSummaryResponse.ReadOnly = new Wrapper(impl)
}
