package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.SensitiveString
import scala.jdk.CollectionConverters.*
final case class DocumentText(
    highlights: Optional[Iterable[zio.aws.wisdom.model.Highlight]] =
      Optional.Absent,
    text: Optional[SensitiveString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.DocumentText = {
    import DocumentText.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.DocumentText
      .builder()
      .optionallyWith(
        highlights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.highlights)
      .optionallyWith(
        text.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.text)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.DocumentText.ReadOnly =
    zio.aws.wisdom.model.DocumentText.wrap(buildAwsValue())
}
object DocumentText {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.DocumentText
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.DocumentText =
      zio.aws.wisdom.model.DocumentText(
        highlights.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        text.map(value => value)
      )
    def highlights: Optional[List[zio.aws.wisdom.model.Highlight.ReadOnly]]
    def text: Optional[SensitiveString]
    def getHighlights
        : ZIO[Any, AwsError, List[zio.aws.wisdom.model.Highlight.ReadOnly]] =
      AwsError.unwrapOptionField("highlights", highlights)
    def getText: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("text", text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.DocumentText
  ) extends zio.aws.wisdom.model.DocumentText.ReadOnly {
    override val highlights
        : Optional[List[zio.aws.wisdom.model.Highlight.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.highlights())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wisdom.model.Highlight.wrap(item)
          }.toList
        )
    override val text: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => zio.aws.wisdom.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.DocumentText
  ): zio.aws.wisdom.model.DocumentText.ReadOnly = new Wrapper(impl)
}
