package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSessionResponse(
    session: Optional[zio.aws.wisdom.model.SessionData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.CreateSessionResponse = {
    import CreateSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.CreateSessionResponse
      .builder()
      .optionallyWith(session.map(value => value.buildAwsValue()))(_.session)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.CreateSessionResponse.ReadOnly =
    zio.aws.wisdom.model.CreateSessionResponse.wrap(buildAwsValue())
}
object CreateSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.CreateSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.CreateSessionResponse =
      zio.aws.wisdom.model
        .CreateSessionResponse(session.map(value => value.asEditable))
    def session: Optional[zio.aws.wisdom.model.SessionData.ReadOnly]
    def getSession
        : ZIO[Any, AwsError, zio.aws.wisdom.model.SessionData.ReadOnly] =
      AwsError.unwrapOptionField("session", session)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.CreateSessionResponse
  ) extends zio.aws.wisdom.model.CreateSessionResponse.ReadOnly {
    override val session: Optional[zio.aws.wisdom.model.SessionData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.session())
        .map(value => zio.aws.wisdom.model.SessionData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.CreateSessionResponse
  ): zio.aws.wisdom.model.CreateSessionResponse.ReadOnly = new Wrapper(impl)
}
