package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.{UuidOrArn, ContentType}
import scala.jdk.CollectionConverters.*
final case class StartContentUploadRequest(
    contentType: ContentType,
    knowledgeBaseId: UuidOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.StartContentUploadRequest = {
    import StartContentUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.StartContentUploadRequest
      .builder()
      .contentType(ContentType.unwrap(contentType): java.lang.String)
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.StartContentUploadRequest.ReadOnly =
    zio.aws.wisdom.model.StartContentUploadRequest.wrap(buildAwsValue())
}
object StartContentUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.StartContentUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.StartContentUploadRequest =
      zio.aws.wisdom.model
        .StartContentUploadRequest(contentType, knowledgeBaseId)
    def contentType: ContentType
    def knowledgeBaseId: UuidOrArn
    def getContentType: ZIO[Any, Nothing, ContentType] =
      ZIO.succeed(contentType)
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.StartContentUploadRequest
  ) extends zio.aws.wisdom.model.StartContentUploadRequest.ReadOnly {
    override val contentType: ContentType =
      zio.aws.wisdom.model.primitives.ContentType(impl.contentType())
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.StartContentUploadRequest
  ): zio.aws.wisdom.model.StartContentUploadRequest.ReadOnly = new Wrapper(impl)
}
