package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.UuidOrArn
import scala.jdk.CollectionConverters.*
final case class NotifyRecommendationsReceivedRequest(
    assistantId: UuidOrArn,
    recommendationIds: Iterable[String],
    sessionId: UuidOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedRequest = {
    import NotifyRecommendationsReceivedRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedRequest
      .builder()
      .assistantId(UuidOrArn.unwrap(assistantId): java.lang.String)
      .recommendationIds(recommendationIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .sessionId(UuidOrArn.unwrap(sessionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.NotifyRecommendationsReceivedRequest.ReadOnly =
    zio.aws.wisdom.model.NotifyRecommendationsReceivedRequest
      .wrap(buildAwsValue())
}
object NotifyRecommendationsReceivedRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.NotifyRecommendationsReceivedRequest =
      zio.aws.wisdom.model.NotifyRecommendationsReceivedRequest(
        assistantId,
        recommendationIds,
        sessionId
      )
    def assistantId: UuidOrArn
    def recommendationIds: List[String]
    def sessionId: UuidOrArn
    def getAssistantId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(assistantId)
    def getRecommendationIds: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(recommendationIds)
    def getSessionId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedRequest
  ) extends zio.aws.wisdom.model.NotifyRecommendationsReceivedRequest.ReadOnly {
    override val assistantId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantId())
    override val recommendationIds: List[String] = impl
      .recommendationIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val sessionId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedRequest
  ): zio.aws.wisdom.model.NotifyRecommendationsReceivedRequest.ReadOnly =
    new Wrapper(impl)
}
