package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{
  TagValue,
  Description,
  ClientToken,
  UuidOrArn,
  Name,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateSessionRequest(
    assistantId: UuidOrArn,
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    name: Name,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.CreateSessionRequest = {
    import CreateSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.CreateSessionRequest
      .builder()
      .assistantId(UuidOrArn.unwrap(assistantId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.CreateSessionRequest.ReadOnly =
    zio.aws.wisdom.model.CreateSessionRequest.wrap(buildAwsValue())
}
object CreateSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.CreateSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.CreateSessionRequest =
      zio.aws.wisdom.model.CreateSessionRequest(
        assistantId,
        clientToken.map(value => value),
        description.map(value => value),
        name,
        tags.map(value => value)
      )
    def assistantId: UuidOrArn
    def clientToken: Optional[ClientToken]
    def description: Optional[Description]
    def name: Name
    def tags: Optional[Map[TagKey, TagValue]]
    def getAssistantId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(assistantId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.CreateSessionRequest
  ) extends zio.aws.wisdom.model.CreateSessionRequest.ReadOnly {
    override val assistantId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.wisdom.model.primitives.ClientToken(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.wisdom.model.primitives.Description(value))
    override val name: Name = zio.aws.wisdom.model.primitives.Name(impl.name())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.CreateSessionRequest
  ): zio.aws.wisdom.model.CreateSessionRequest.ReadOnly = new Wrapper(impl)
}
