package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{
  ContentTitle,
  Uri,
  NonEmptyString,
  UuidOrArn
}
import scala.jdk.CollectionConverters.*
final case class UpdateContentRequest(
    contentId: UuidOrArn,
    knowledgeBaseId: UuidOrArn,
    metadata: Optional[Map[NonEmptyString, NonEmptyString]] = Optional.Absent,
    overrideLinkOutUri: Optional[Uri] = Optional.Absent,
    removeOverrideLinkOutUri: Optional[Boolean] = Optional.Absent,
    revisionId: Optional[NonEmptyString] = Optional.Absent,
    title: Optional[ContentTitle] = Optional.Absent,
    uploadId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.UpdateContentRequest = {
    import UpdateContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.UpdateContentRequest
      .builder()
      .contentId(UuidOrArn.unwrap(contentId): java.lang.String)
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(
        overrideLinkOutUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.overrideLinkOutUri)
      .optionallyWith(
        removeOverrideLinkOutUri.map(value => value: java.lang.Boolean)
      )(_.removeOverrideLinkOutUri)
      .optionallyWith(
        revisionId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(
        title.map(value => ContentTitle.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        uploadId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.uploadId)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.UpdateContentRequest.ReadOnly =
    zio.aws.wisdom.model.UpdateContentRequest.wrap(buildAwsValue())
}
object UpdateContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.UpdateContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.UpdateContentRequest =
      zio.aws.wisdom.model.UpdateContentRequest(
        contentId,
        knowledgeBaseId,
        metadata.map(value => value),
        overrideLinkOutUri.map(value => value),
        removeOverrideLinkOutUri.map(value => value),
        revisionId.map(value => value),
        title.map(value => value),
        uploadId.map(value => value)
      )
    def contentId: UuidOrArn
    def knowledgeBaseId: UuidOrArn
    def metadata: Optional[Map[NonEmptyString, NonEmptyString]]
    def overrideLinkOutUri: Optional[Uri]
    def removeOverrideLinkOutUri: Optional[Boolean]
    def revisionId: Optional[NonEmptyString]
    def title: Optional[ContentTitle]
    def uploadId: Optional[NonEmptyString]
    def getContentId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(contentId)
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
    def getMetadata: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getOverrideLinkOutUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("overrideLinkOutUri", overrideLinkOutUri)
    def getRemoveOverrideLinkOutUri: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("removeOverrideLinkOutUri", removeOverrideLinkOutUri)
    def getRevisionId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getTitle: ZIO[Any, AwsError, ContentTitle] =
      AwsError.unwrapOptionField("title", title)
    def getUploadId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("uploadId", uploadId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.UpdateContentRequest
  ) extends zio.aws.wisdom.model.UpdateContentRequest.ReadOnly {
    override val contentId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.contentId())
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
    override val metadata: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.wisdom.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.wisdom.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val overrideLinkOutUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.overrideLinkOutUri())
      .map(value => zio.aws.wisdom.model.primitives.Uri(value))
    override val removeOverrideLinkOutUri: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeOverrideLinkOutUri())
        .map(value => value: Boolean)
    override val revisionId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
    override val title: Optional[ContentTitle] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.wisdom.model.primitives.ContentTitle(value))
    override val uploadId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadId())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.UpdateContentRequest
  ): zio.aws.wisdom.model.UpdateContentRequest.ReadOnly = new Wrapper(impl)
}
