package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.wisdom.model.primitives.{
  SyntheticTimestamp_epoch_seconds,
  Url,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class StartContentUploadResponse(
    headersToInclude: Map[NonEmptyString, NonEmptyString],
    uploadId: NonEmptyString,
    url: Url,
    urlExpiry: SyntheticTimestamp_epoch_seconds
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.StartContentUploadResponse = {
    import StartContentUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.StartContentUploadResponse
      .builder()
      .headersToInclude(
        headersToInclude
          .map({ case (key, value) =>
            (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .uploadId(NonEmptyString.unwrap(uploadId): java.lang.String)
      .url(Url.unwrap(url): java.lang.String)
      .urlExpiry(SyntheticTimestamp_epoch_seconds.unwrap(urlExpiry): Instant)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.StartContentUploadResponse.ReadOnly =
    zio.aws.wisdom.model.StartContentUploadResponse.wrap(buildAwsValue())
}
object StartContentUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.StartContentUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.StartContentUploadResponse =
      zio.aws.wisdom.model.StartContentUploadResponse(
        headersToInclude,
        uploadId,
        url,
        urlExpiry
      )
    def headersToInclude: Map[NonEmptyString, NonEmptyString]
    def uploadId: NonEmptyString
    def url: Url
    def urlExpiry: SyntheticTimestamp_epoch_seconds
    def getHeadersToInclude
        : ZIO[Any, Nothing, Map[NonEmptyString, NonEmptyString]] =
      ZIO.succeed(headersToInclude)
    def getUploadId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(uploadId)
    def getUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(url)
    def getUrlExpiry: ZIO[Any, Nothing, SyntheticTimestamp_epoch_seconds] =
      ZIO.succeed(urlExpiry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.StartContentUploadResponse
  ) extends zio.aws.wisdom.model.StartContentUploadResponse.ReadOnly {
    override val headersToInclude: Map[NonEmptyString, NonEmptyString] = impl
      .headersToInclude()
      .asScala
      .map({ case (key, value) =>
        zio.aws.wisdom.model.primitives.NonEmptyString(
          key
        ) -> zio.aws.wisdom.model.primitives.NonEmptyString(value)
      })
      .toMap
    override val uploadId: NonEmptyString =
      zio.aws.wisdom.model.primitives.NonEmptyString(impl.uploadId())
    override val url: Url = zio.aws.wisdom.model.primitives.Url(impl.url())
    override val urlExpiry: SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives
        .SyntheticTimestamp_epoch_seconds(impl.urlExpiry())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.StartContentUploadResponse
  ): zio.aws.wisdom.model.StartContentUploadResponse.ReadOnly = new Wrapper(
    impl
  )
}
