package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait RecommendationType {
  def unwrap: software.amazon.awssdk.services.wisdom.model.RecommendationType
}
object RecommendationType {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.RecommendationType
  ): zio.aws.wisdom.model.RecommendationType = value match {
    case software.amazon.awssdk.services.wisdom.model.RecommendationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.RecommendationType.KNOWLEDGE_CONTENT =>
      val r = KNOWLEDGE_CONTENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wisdom.model.RecommendationType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.RecommendationType =
      software.amazon.awssdk.services.wisdom.model.RecommendationType.UNKNOWN_TO_SDK_VERSION
  }
  case object KNOWLEDGE_CONTENT
      extends zio.aws.wisdom.model.RecommendationType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.RecommendationType =
      software.amazon.awssdk.services.wisdom.model.RecommendationType.KNOWLEDGE_CONTENT
  }
}
