package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.UuidOrArn
import scala.jdk.CollectionConverters.*
final case class GetAssistantAssociationRequest(
    assistantAssociationId: UuidOrArn,
    assistantId: UuidOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationRequest = {
    import GetAssistantAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationRequest
      .builder()
      .assistantAssociationId(
        UuidOrArn.unwrap(assistantAssociationId): java.lang.String
      )
      .assistantId(UuidOrArn.unwrap(assistantId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetAssistantAssociationRequest.ReadOnly =
    zio.aws.wisdom.model.GetAssistantAssociationRequest.wrap(buildAwsValue())
}
object GetAssistantAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetAssistantAssociationRequest =
      zio.aws.wisdom.model
        .GetAssistantAssociationRequest(assistantAssociationId, assistantId)
    def assistantAssociationId: UuidOrArn
    def assistantId: UuidOrArn
    def getAssistantAssociationId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(assistantAssociationId)
    def getAssistantId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(assistantId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationRequest
  ) extends zio.aws.wisdom.model.GetAssistantAssociationRequest.ReadOnly {
    override val assistantAssociationId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantAssociationId())
    override val assistantId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationRequest
  ): zio.aws.wisdom.model.GetAssistantAssociationRequest.ReadOnly = new Wrapper(
    impl
  )
}
