package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{
  ContentTitle,
  TagValue,
  Uri,
  UuidOrArn,
  Name,
  NonEmptyString,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateContentRequest(
    clientToken: Optional[NonEmptyString] = Optional.Absent,
    knowledgeBaseId: UuidOrArn,
    metadata: Optional[Map[NonEmptyString, NonEmptyString]] = Optional.Absent,
    name: Name,
    overrideLinkOutUri: Optional[Uri] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    title: Optional[ContentTitle] = Optional.Absent,
    uploadId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.CreateContentRequest = {
    import CreateContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.CreateContentRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.clientToken)
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        overrideLinkOutUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.overrideLinkOutUri)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        title.map(value => ContentTitle.unwrap(value): java.lang.String)
      )(_.title)
      .uploadId(NonEmptyString.unwrap(uploadId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.CreateContentRequest.ReadOnly =
    zio.aws.wisdom.model.CreateContentRequest.wrap(buildAwsValue())
}
object CreateContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.CreateContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.CreateContentRequest =
      zio.aws.wisdom.model.CreateContentRequest(
        clientToken.map(value => value),
        knowledgeBaseId,
        metadata.map(value => value),
        name,
        overrideLinkOutUri.map(value => value),
        tags.map(value => value),
        title.map(value => value),
        uploadId
      )
    def clientToken: Optional[NonEmptyString]
    def knowledgeBaseId: UuidOrArn
    def metadata: Optional[Map[NonEmptyString, NonEmptyString]]
    def name: Name
    def overrideLinkOutUri: Optional[Uri]
    def tags: Optional[Map[TagKey, TagValue]]
    def title: Optional[ContentTitle]
    def uploadId: NonEmptyString
    def getClientToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
    def getMetadata: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getOverrideLinkOutUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("overrideLinkOutUri", overrideLinkOutUri)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTitle: ZIO[Any, AwsError, ContentTitle] =
      AwsError.unwrapOptionField("title", title)
    def getUploadId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(uploadId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.CreateContentRequest
  ) extends zio.aws.wisdom.model.CreateContentRequest.ReadOnly {
    override val clientToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
    override val metadata: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.wisdom.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.wisdom.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val name: Name = zio.aws.wisdom.model.primitives.Name(impl.name())
    override val overrideLinkOutUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.overrideLinkOutUri())
      .map(value => zio.aws.wisdom.model.primitives.Uri(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val title: Optional[ContentTitle] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.wisdom.model.primitives.ContentTitle(value))
    override val uploadId: NonEmptyString =
      zio.aws.wisdom.model.primitives.NonEmptyString(impl.uploadId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.CreateContentRequest
  ): zio.aws.wisdom.model.CreateContentRequest.ReadOnly = new Wrapper(impl)
}
