package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait ContentStatus {
  def unwrap: software.amazon.awssdk.services.wisdom.model.ContentStatus
}
object ContentStatus {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.ContentStatus
  ): zio.aws.wisdom.model.ContentStatus = value match {
    case software.amazon.awssdk.services.wisdom.model.ContentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.ContentStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.wisdom.model.ContentStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.wisdom.model.ContentStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.wisdom.model.ContentStatus.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.wisdom.model.ContentStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.wisdom.model.ContentStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.wisdom.model.ContentStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.wisdom.model.ContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ContentStatus =
      software.amazon.awssdk.services.wisdom.model.ContentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS extends zio.aws.wisdom.model.ContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ContentStatus =
      software.amazon.awssdk.services.wisdom.model.ContentStatus.CREATE_IN_PROGRESS
  }
  case object CREATE_FAILED extends zio.aws.wisdom.model.ContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ContentStatus =
      software.amazon.awssdk.services.wisdom.model.ContentStatus.CREATE_FAILED
  }
  case object ACTIVE extends zio.aws.wisdom.model.ContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ContentStatus =
      software.amazon.awssdk.services.wisdom.model.ContentStatus.ACTIVE
  }
  case object DELETE_IN_PROGRESS extends zio.aws.wisdom.model.ContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ContentStatus =
      software.amazon.awssdk.services.wisdom.model.ContentStatus.DELETE_IN_PROGRESS
  }
  case object DELETE_FAILED extends zio.aws.wisdom.model.ContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ContentStatus =
      software.amazon.awssdk.services.wisdom.model.ContentStatus.DELETE_FAILED
  }
  case object DELETED extends zio.aws.wisdom.model.ContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ContentStatus =
      software.amazon.awssdk.services.wisdom.model.ContentStatus.DELETED
  }
  case object UPDATE_FAILED extends zio.aws.wisdom.model.ContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ContentStatus =
      software.amazon.awssdk.services.wisdom.model.ContentStatus.UPDATE_FAILED
  }
}
