package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.RelevanceScore
import scala.jdk.CollectionConverters.*
final case class RecommendationData(
    document: zio.aws.wisdom.model.Document,
    recommendationId: String,
    relevanceLevel: Optional[zio.aws.wisdom.model.RelevanceLevel] =
      Optional.Absent,
    relevanceScore: Optional[RelevanceScore] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.RecommendationData = {
    import RecommendationData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.RecommendationData
      .builder()
      .document(document.buildAwsValue())
      .recommendationId(recommendationId: java.lang.String)
      .optionallyWith(relevanceLevel.map(value => value.unwrap))(
        _.relevanceLevel
      )
      .optionallyWith(
        relevanceScore.map(value =>
          RelevanceScore.unwrap(value): java.lang.Double
        )
      )(_.relevanceScore)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.RecommendationData.ReadOnly =
    zio.aws.wisdom.model.RecommendationData.wrap(buildAwsValue())
}
object RecommendationData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.RecommendationData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.RecommendationData =
      zio.aws.wisdom.model.RecommendationData(
        document.asEditable,
        recommendationId,
        relevanceLevel.map(value => value),
        relevanceScore.map(value => value)
      )
    def document: zio.aws.wisdom.model.Document.ReadOnly
    def recommendationId: String
    def relevanceLevel: Optional[zio.aws.wisdom.model.RelevanceLevel]
    def relevanceScore: Optional[RelevanceScore]
    def getDocument: ZIO[Any, Nothing, zio.aws.wisdom.model.Document.ReadOnly] =
      ZIO.succeed(document)
    def getRecommendationId: ZIO[Any, Nothing, String] =
      ZIO.succeed(recommendationId)
    def getRelevanceLevel
        : ZIO[Any, AwsError, zio.aws.wisdom.model.RelevanceLevel] =
      AwsError.unwrapOptionField("relevanceLevel", relevanceLevel)
    def getRelevanceScore: ZIO[Any, AwsError, RelevanceScore] =
      AwsError.unwrapOptionField("relevanceScore", relevanceScore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.RecommendationData
  ) extends zio.aws.wisdom.model.RecommendationData.ReadOnly {
    override val document: zio.aws.wisdom.model.Document.ReadOnly =
      zio.aws.wisdom.model.Document.wrap(impl.document())
    override val recommendationId: String = impl.recommendationId(): String
    override val relevanceLevel: Optional[zio.aws.wisdom.model.RelevanceLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relevanceLevel())
        .map(value => zio.aws.wisdom.model.RelevanceLevel.wrap(value))
    override val relevanceScore: Optional[RelevanceScore] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relevanceScore())
        .map(value => zio.aws.wisdom.model.primitives.RelevanceScore(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.RecommendationData
  ): zio.aws.wisdom.model.RecommendationData.ReadOnly = new Wrapper(impl)
}
