package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{
  SyntheticTimestamp_epoch_seconds,
  TagValue,
  Arn,
  Uuid,
  Description,
  Name,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class KnowledgeBaseData(
    description: Optional[Description] = Optional.Absent,
    knowledgeBaseArn: Arn,
    knowledgeBaseId: Uuid,
    knowledgeBaseType: zio.aws.wisdom.model.KnowledgeBaseType,
    lastContentModificationTime: Optional[SyntheticTimestamp_epoch_seconds] =
      Optional.Absent,
    name: Name,
    renderingConfiguration: Optional[
      zio.aws.wisdom.model.RenderingConfiguration
    ] = Optional.Absent,
    serverSideEncryptionConfiguration: Optional[
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration
    ] = Optional.Absent,
    sourceConfiguration: Optional[zio.aws.wisdom.model.SourceConfiguration] =
      Optional.Absent,
    status: zio.aws.wisdom.model.KnowledgeBaseStatus,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.KnowledgeBaseData = {
    import KnowledgeBaseData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.KnowledgeBaseData
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .knowledgeBaseArn(Arn.unwrap(knowledgeBaseArn): java.lang.String)
      .knowledgeBaseId(Uuid.unwrap(knowledgeBaseId): java.lang.String)
      .knowledgeBaseType(knowledgeBaseType.unwrap)
      .optionallyWith(
        lastContentModificationTime.map(value =>
          SyntheticTimestamp_epoch_seconds.unwrap(value): Instant
        )
      )(_.lastContentModificationTime)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        renderingConfiguration.map(value => value.buildAwsValue())
      )(_.renderingConfiguration)
      .optionallyWith(
        serverSideEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.serverSideEncryptionConfiguration)
      .optionallyWith(sourceConfiguration.map(value => value.buildAwsValue()))(
        _.sourceConfiguration
      )
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.KnowledgeBaseData.ReadOnly =
    zio.aws.wisdom.model.KnowledgeBaseData.wrap(buildAwsValue())
}
object KnowledgeBaseData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.KnowledgeBaseData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.KnowledgeBaseData =
      zio.aws.wisdom.model.KnowledgeBaseData(
        description.map(value => value),
        knowledgeBaseArn,
        knowledgeBaseId,
        knowledgeBaseType,
        lastContentModificationTime.map(value => value),
        name,
        renderingConfiguration.map(value => value.asEditable),
        serverSideEncryptionConfiguration.map(value => value.asEditable),
        sourceConfiguration.map(value => value.asEditable),
        status,
        tags.map(value => value)
      )
    def description: Optional[Description]
    def knowledgeBaseArn: Arn
    def knowledgeBaseId: Uuid
    def knowledgeBaseType: zio.aws.wisdom.model.KnowledgeBaseType
    def lastContentModificationTime: Optional[SyntheticTimestamp_epoch_seconds]
    def name: Name
    def renderingConfiguration
        : Optional[zio.aws.wisdom.model.RenderingConfiguration.ReadOnly]
    def serverSideEncryptionConfiguration: Optional[
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly
    ]
    def sourceConfiguration
        : Optional[zio.aws.wisdom.model.SourceConfiguration.ReadOnly]
    def status: zio.aws.wisdom.model.KnowledgeBaseStatus
    def tags: Optional[Map[TagKey, TagValue]]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getKnowledgeBaseArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(knowledgeBaseArn)
    def getKnowledgeBaseId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(knowledgeBaseId)
    def getKnowledgeBaseType
        : ZIO[Any, Nothing, zio.aws.wisdom.model.KnowledgeBaseType] =
      ZIO.succeed(knowledgeBaseType)
    def getLastContentModificationTime
        : ZIO[Any, AwsError, SyntheticTimestamp_epoch_seconds] =
      AwsError.unwrapOptionField(
        "lastContentModificationTime",
        lastContentModificationTime
      )
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getRenderingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.RenderingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "renderingConfiguration",
      renderingConfiguration
    )
    def getServerSideEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverSideEncryptionConfiguration",
      serverSideEncryptionConfiguration
    )
    def getSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.SourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sourceConfiguration", sourceConfiguration)
    def getStatus: ZIO[Any, Nothing, zio.aws.wisdom.model.KnowledgeBaseStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.KnowledgeBaseData
  ) extends zio.aws.wisdom.model.KnowledgeBaseData.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.wisdom.model.primitives.Description(value))
    override val knowledgeBaseArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.knowledgeBaseArn())
    override val knowledgeBaseId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.knowledgeBaseId())
    override val knowledgeBaseType: zio.aws.wisdom.model.KnowledgeBaseType =
      zio.aws.wisdom.model.KnowledgeBaseType.wrap(impl.knowledgeBaseType())
    override val lastContentModificationTime
        : Optional[SyntheticTimestamp_epoch_seconds] = zio.aws.core.internal
      .optionalFromNullable(impl.lastContentModificationTime())
      .map(value =>
        zio.aws.wisdom.model.primitives.SyntheticTimestamp_epoch_seconds(value)
      )
    override val name: Name = zio.aws.wisdom.model.primitives.Name(impl.name())
    override val renderingConfiguration
        : Optional[zio.aws.wisdom.model.RenderingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renderingConfiguration())
        .map(value => zio.aws.wisdom.model.RenderingConfiguration.wrap(value))
    override val serverSideEncryptionConfiguration: Optional[
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideEncryptionConfiguration())
      .map(value =>
        zio.aws.wisdom.model.ServerSideEncryptionConfiguration.wrap(value)
      )
    override val sourceConfiguration
        : Optional[zio.aws.wisdom.model.SourceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceConfiguration())
        .map(value => zio.aws.wisdom.model.SourceConfiguration.wrap(value))
    override val status: zio.aws.wisdom.model.KnowledgeBaseStatus =
      zio.aws.wisdom.model.KnowledgeBaseStatus.wrap(impl.status())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.KnowledgeBaseData
  ): zio.aws.wisdom.model.KnowledgeBaseData.ReadOnly = new Wrapper(impl)
}
