package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRecommendationsResponse(
    recommendations: Iterable[zio.aws.wisdom.model.RecommendationData]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetRecommendationsResponse = {
    import GetRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetRecommendationsResponse
      .builder()
      .recommendations(recommendations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetRecommendationsResponse.ReadOnly =
    zio.aws.wisdom.model.GetRecommendationsResponse.wrap(buildAwsValue())
}
object GetRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetRecommendationsResponse =
      zio.aws.wisdom.model.GetRecommendationsResponse(recommendations.map {
        item =>
          item.asEditable
      })
    def recommendations: List[zio.aws.wisdom.model.RecommendationData.ReadOnly]
    def getRecommendations: ZIO[Any, Nothing, List[
      zio.aws.wisdom.model.RecommendationData.ReadOnly
    ]] = ZIO.succeed(recommendations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetRecommendationsResponse
  ) extends zio.aws.wisdom.model.GetRecommendationsResponse.ReadOnly {
    override val recommendations
        : List[zio.aws.wisdom.model.RecommendationData.ReadOnly] = impl
      .recommendations()
      .asScala
      .map { item =>
        zio.aws.wisdom.model.RecommendationData.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetRecommendationsResponse
  ): zio.aws.wisdom.model.GetRecommendationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
