package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAssistantResponse(
    assistant: Optional[zio.aws.wisdom.model.AssistantData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetAssistantResponse = {
    import GetAssistantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetAssistantResponse
      .builder()
      .optionallyWith(assistant.map(value => value.buildAwsValue()))(
        _.assistant
      )
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetAssistantResponse.ReadOnly =
    zio.aws.wisdom.model.GetAssistantResponse.wrap(buildAwsValue())
}
object GetAssistantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetAssistantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetAssistantResponse =
      zio.aws.wisdom.model
        .GetAssistantResponse(assistant.map(value => value.asEditable))
    def assistant: Optional[zio.aws.wisdom.model.AssistantData.ReadOnly]
    def getAssistant
        : ZIO[Any, AwsError, zio.aws.wisdom.model.AssistantData.ReadOnly] =
      AwsError.unwrapOptionField("assistant", assistant)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetAssistantResponse
  ) extends zio.aws.wisdom.model.GetAssistantResponse.ReadOnly {
    override val assistant
        : Optional[zio.aws.wisdom.model.AssistantData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assistant())
        .map(value => zio.aws.wisdom.model.AssistantData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetAssistantResponse
  ): zio.aws.wisdom.model.GetAssistantResponse.ReadOnly = new Wrapper(impl)
}
