package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Document(
    contentReference: zio.aws.wisdom.model.ContentReference,
    excerpt: Optional[zio.aws.wisdom.model.DocumentText] = Optional.Absent,
    title: Optional[zio.aws.wisdom.model.DocumentText] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.wisdom.model.Document = {
    import Document.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.Document
      .builder()
      .contentReference(contentReference.buildAwsValue())
      .optionallyWith(excerpt.map(value => value.buildAwsValue()))(_.excerpt)
      .optionallyWith(title.map(value => value.buildAwsValue()))(_.title)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.Document.ReadOnly =
    zio.aws.wisdom.model.Document.wrap(buildAwsValue())
}
object Document {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wisdom.model.Document] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.Document =
      zio.aws.wisdom.model.Document(
        contentReference.asEditable,
        excerpt.map(value => value.asEditable),
        title.map(value => value.asEditable)
      )
    def contentReference: zio.aws.wisdom.model.ContentReference.ReadOnly
    def excerpt: Optional[zio.aws.wisdom.model.DocumentText.ReadOnly]
    def title: Optional[zio.aws.wisdom.model.DocumentText.ReadOnly]
    def getContentReference
        : ZIO[Any, Nothing, zio.aws.wisdom.model.ContentReference.ReadOnly] =
      ZIO.succeed(contentReference)
    def getExcerpt
        : ZIO[Any, AwsError, zio.aws.wisdom.model.DocumentText.ReadOnly] =
      AwsError.unwrapOptionField("excerpt", excerpt)
    def getTitle
        : ZIO[Any, AwsError, zio.aws.wisdom.model.DocumentText.ReadOnly] =
      AwsError.unwrapOptionField("title", title)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.Document
  ) extends zio.aws.wisdom.model.Document.ReadOnly {
    override val contentReference
        : zio.aws.wisdom.model.ContentReference.ReadOnly =
      zio.aws.wisdom.model.ContentReference.wrap(impl.contentReference())
    override val excerpt: Optional[zio.aws.wisdom.model.DocumentText.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excerpt())
        .map(value => zio.aws.wisdom.model.DocumentText.wrap(value))
    override val title: Optional[zio.aws.wisdom.model.DocumentText.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.title())
        .map(value => zio.aws.wisdom.model.DocumentText.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.Document
  ): zio.aws.wisdom.model.Document.ReadOnly = new Wrapper(impl)
}
