package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAssistantResponse(
    assistant: Optional[zio.aws.wisdom.model.AssistantData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.CreateAssistantResponse = {
    import CreateAssistantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.CreateAssistantResponse
      .builder()
      .optionallyWith(assistant.map(value => value.buildAwsValue()))(
        _.assistant
      )
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.CreateAssistantResponse.ReadOnly =
    zio.aws.wisdom.model.CreateAssistantResponse.wrap(buildAwsValue())
}
object CreateAssistantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.CreateAssistantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.CreateAssistantResponse =
      zio.aws.wisdom.model
        .CreateAssistantResponse(assistant.map(value => value.asEditable))
    def assistant: Optional[zio.aws.wisdom.model.AssistantData.ReadOnly]
    def getAssistant
        : ZIO[Any, AwsError, zio.aws.wisdom.model.AssistantData.ReadOnly] =
      AwsError.unwrapOptionField("assistant", assistant)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.CreateAssistantResponse
  ) extends zio.aws.wisdom.model.CreateAssistantResponse.ReadOnly {
    override val assistant
        : Optional[zio.aws.wisdom.model.AssistantData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assistant())
        .map(value => zio.aws.wisdom.model.AssistantData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.CreateAssistantResponse
  ): zio.aws.wisdom.model.CreateAssistantResponse.ReadOnly = new Wrapper(impl)
}
