package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{TagValue, TagKey, Uuid, Arn}
import scala.jdk.CollectionConverters.*
final case class AssistantAssociationData(
    assistantArn: Arn,
    assistantAssociationArn: Arn,
    assistantAssociationId: Uuid,
    assistantId: Uuid,
    associationData: zio.aws.wisdom.model.AssistantAssociationOutputData,
    associationType: zio.aws.wisdom.model.AssociationType,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.AssistantAssociationData = {
    import AssistantAssociationData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.AssistantAssociationData
      .builder()
      .assistantArn(Arn.unwrap(assistantArn): java.lang.String)
      .assistantAssociationArn(
        Arn.unwrap(assistantAssociationArn): java.lang.String
      )
      .assistantAssociationId(
        Uuid.unwrap(assistantAssociationId): java.lang.String
      )
      .assistantId(Uuid.unwrap(assistantId): java.lang.String)
      .associationData(associationData.buildAwsValue())
      .associationType(associationType.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.AssistantAssociationData.ReadOnly =
    zio.aws.wisdom.model.AssistantAssociationData.wrap(buildAwsValue())
}
object AssistantAssociationData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.AssistantAssociationData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.AssistantAssociationData =
      zio.aws.wisdom.model.AssistantAssociationData(
        assistantArn,
        assistantAssociationArn,
        assistantAssociationId,
        assistantId,
        associationData.asEditable,
        associationType,
        tags.map(value => value)
      )
    def assistantArn: Arn
    def assistantAssociationArn: Arn
    def assistantAssociationId: Uuid
    def assistantId: Uuid
    def associationData
        : zio.aws.wisdom.model.AssistantAssociationOutputData.ReadOnly
    def associationType: zio.aws.wisdom.model.AssociationType
    def tags: Optional[Map[TagKey, TagValue]]
    def getAssistantArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(assistantArn)
    def getAssistantAssociationArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assistantAssociationArn)
    def getAssistantAssociationId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(assistantAssociationId)
    def getAssistantId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(assistantId)
    def getAssociationData: ZIO[
      Any,
      Nothing,
      zio.aws.wisdom.model.AssistantAssociationOutputData.ReadOnly
    ] = ZIO.succeed(associationData)
    def getAssociationType
        : ZIO[Any, Nothing, zio.aws.wisdom.model.AssociationType] =
      ZIO.succeed(associationType)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.AssistantAssociationData
  ) extends zio.aws.wisdom.model.AssistantAssociationData.ReadOnly {
    override val assistantArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.assistantArn())
    override val assistantAssociationArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.assistantAssociationArn())
    override val assistantAssociationId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.assistantAssociationId())
    override val assistantId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.assistantId())
    override val associationData
        : zio.aws.wisdom.model.AssistantAssociationOutputData.ReadOnly =
      zio.aws.wisdom.model.AssistantAssociationOutputData
        .wrap(impl.associationData())
    override val associationType: zio.aws.wisdom.model.AssociationType =
      zio.aws.wisdom.model.AssociationType.wrap(impl.associationType())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.AssistantAssociationData
  ): zio.aws.wisdom.model.AssistantAssociationData.ReadOnly = new Wrapper(impl)
}
