package zio.aws.wisdom
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.wisdom.model.primitives.QueryText.Type
import zio.aws.wisdom.model.primitives.{TagValue, TagKey, NonEmptyString}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.wisdom.model.primitives.Arn.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.wisdom.model.primitives.ClientToken.Type
    object ContentTitle extends Subtype[String]
    type ContentTitle = zio.aws.wisdom.model.primitives.ContentTitle.Type
    object ContentType extends Subtype[String]
    type ContentType = zio.aws.wisdom.model.primitives.ContentType.Type
    object Description extends Subtype[String]
    type Description = zio.aws.wisdom.model.primitives.Description.Type
    object GenericArn extends Subtype[String]
    type GenericArn = zio.aws.wisdom.model.primitives.GenericArn.Type
    object HighlightOffset extends Subtype[Int]
    type HighlightOffset = zio.aws.wisdom.model.primitives.HighlightOffset.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.wisdom.model.primitives.MaxResults.Type
    object Name extends Subtype[String]
    type Name = zio.aws.wisdom.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.wisdom.model.primitives.NextToken.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString = zio.aws.wisdom.model.primitives.NonEmptyString.Type
    object NotifyRecommendationsReceivedErrorMessage extends Subtype[String]
    type NotifyRecommendationsReceivedErrorMessage =
      zio.aws.wisdom.model.primitives.NotifyRecommendationsReceivedErrorMessage.Type
    object QueryText extends Subtype[String]
    type QueryText = zio.aws.wisdom.model.primitives.QueryText.Type
    object RelevanceScore extends Subtype[Double]
    type RelevanceScore = zio.aws.wisdom.model.primitives.RelevanceScore.Type
    object SyntheticContentDataUrl extends Subtype[String]
    type SyntheticContentDataUrl =
      zio.aws.wisdom.model.primitives.SyntheticContentDataUrl.Type
    object SyntheticDocumentTextString extends Subtype[String]
    type SyntheticDocumentTextString =
      zio.aws.wisdom.model.primitives.SyntheticDocumentTextString.Type
    object SyntheticStartContentUploadResponseUrl extends Subtype[String]
    type SyntheticStartContentUploadResponseUrl =
      zio.aws.wisdom.model.primitives.SyntheticStartContentUploadResponseUrl.Type
    object SyntheticTimestamp_epoch_seconds extends Subtype[Instant]
    type SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives.SyntheticTimestamp_epoch_seconds.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.wisdom.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.wisdom.model.primitives.TagValue.Type
    object Uri extends Subtype[String]
    type Uri = zio.aws.wisdom.model.primitives.Uri.Type
    object Uuid extends Subtype[String]
    type Uuid = zio.aws.wisdom.model.primitives.Uuid.Type
    object UuidOrArn extends Subtype[String]
    type UuidOrArn = zio.aws.wisdom.model.primitives.UuidOrArn.Type
    object WaitTimeSeconds extends Subtype[Int]
    type WaitTimeSeconds = zio.aws.wisdom.model.primitives.WaitTimeSeconds.Type
  }
  type AssistantAssociationSummaryList =
    List[zio.aws.wisdom.model.AssistantAssociationSummary]
  type AssistantList = List[zio.aws.wisdom.model.AssistantSummary]
  type ContentMetadata = Map[NonEmptyString, NonEmptyString]
  type ContentSummaryList = List[zio.aws.wisdom.model.ContentSummary]
  type FilterList = List[zio.aws.wisdom.model.Filter]
  type Headers = Map[NonEmptyString, NonEmptyString]
  type Highlights = List[zio.aws.wisdom.model.Highlight]
  type KnowledgeBaseList = List[zio.aws.wisdom.model.KnowledgeBaseSummary]
  type NotifyRecommendationsReceivedErrorList =
    List[zio.aws.wisdom.model.NotifyRecommendationsReceivedError]
  type ObjectFieldsList = List[NonEmptyString]
  type QueryResultsList = List[zio.aws.wisdom.model.ResultData]
  type RecommendationIdList = List[String]
  type RecommendationList = List[zio.aws.wisdom.model.RecommendationData]
  type SessionSummaries = List[zio.aws.wisdom.model.SessionSummary]
  type TagKeyList = List[TagKey]
  type Tags = Map[TagKey, TagValue]
}
