package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class ServerSideEncryptionConfiguration(
    kmsKeyId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ServerSideEncryptionConfiguration = {
    import ServerSideEncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ServerSideEncryptionConfiguration
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly =
    zio.aws.wisdom.model.ServerSideEncryptionConfiguration.wrap(buildAwsValue())
}
object ServerSideEncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ServerSideEncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ServerSideEncryptionConfiguration =
      zio.aws.wisdom.model
        .ServerSideEncryptionConfiguration(kmsKeyId.map(value => value))
    def kmsKeyId: Option[NonEmptyString]
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ServerSideEncryptionConfiguration
  ) extends zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly {
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ServerSideEncryptionConfiguration
  ): zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
