package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SearchExpression(
    filters: Iterable[zio.aws.wisdom.model.Filter]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.SearchExpression = {
    import SearchExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.SearchExpression
      .builder()
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.SearchExpression.ReadOnly =
    zio.aws.wisdom.model.SearchExpression.wrap(buildAwsValue())
}
object SearchExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.SearchExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.SearchExpression =
      zio.aws.wisdom.model.SearchExpression(filters.map { item =>
        item.asEditable
      })
    def filters: List[zio.aws.wisdom.model.Filter.ReadOnly]
    def getFilters
        : ZIO[Any, Nothing, List[zio.aws.wisdom.model.Filter.ReadOnly]] =
      ZIO.succeed(filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.SearchExpression
  ) extends zio.aws.wisdom.model.SearchExpression.ReadOnly {
    override val filters: List[zio.aws.wisdom.model.Filter.ReadOnly] = impl
      .filters()
      .asScala
      .map { item =>
        zio.aws.wisdom.model.Filter.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.SearchExpression
  ): zio.aws.wisdom.model.SearchExpression.ReadOnly = new Wrapper(impl)
}
