package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSessionResponse(
    session: Option[zio.aws.wisdom.model.SessionData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetSessionResponse = {
    import GetSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetSessionResponse
      .builder()
      .optionallyWith(session.map(value => value.buildAwsValue()))(_.session)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetSessionResponse.ReadOnly =
    zio.aws.wisdom.model.GetSessionResponse.wrap(buildAwsValue())
}
object GetSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetSessionResponse =
      zio.aws.wisdom.model
        .GetSessionResponse(session.map(value => value.asEditable))
    def session: Option[zio.aws.wisdom.model.SessionData.ReadOnly]
    def getSession
        : ZIO[Any, AwsError, zio.aws.wisdom.model.SessionData.ReadOnly] =
      AwsError.unwrapOptionField("session", session)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetSessionResponse
  ) extends zio.aws.wisdom.model.GetSessionResponse.ReadOnly {
    override val session: Option[zio.aws.wisdom.model.SessionData.ReadOnly] =
      scala
        .Option(impl.session())
        .map(value => zio.aws.wisdom.model.SessionData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetSessionResponse
  ): zio.aws.wisdom.model.GetSessionResponse.ReadOnly = new Wrapper(impl)
}
