package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.UuidOrArn
import scala.jdk.CollectionConverters.*
final case class GetKnowledgeBaseRequest(knowledgeBaseId: UuidOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseRequest = {
    import GetKnowledgeBaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseRequest
      .builder()
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetKnowledgeBaseRequest.ReadOnly =
    zio.aws.wisdom.model.GetKnowledgeBaseRequest.wrap(buildAwsValue())
}
object GetKnowledgeBaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetKnowledgeBaseRequest =
      zio.aws.wisdom.model.GetKnowledgeBaseRequest(knowledgeBaseId)
    def knowledgeBaseId: UuidOrArn
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseRequest
  ) extends zio.aws.wisdom.model.GetKnowledgeBaseRequest.ReadOnly {
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseRequest
  ): zio.aws.wisdom.model.GetKnowledgeBaseRequest.ReadOnly = new Wrapper(impl)
}
