package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateContentResponse(
    content: Option[zio.aws.wisdom.model.ContentData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.CreateContentResponse = {
    import CreateContentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.CreateContentResponse
      .builder()
      .optionallyWith(content.map(value => value.buildAwsValue()))(_.content)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.CreateContentResponse.ReadOnly =
    zio.aws.wisdom.model.CreateContentResponse.wrap(buildAwsValue())
}
object CreateContentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.CreateContentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.CreateContentResponse =
      zio.aws.wisdom.model
        .CreateContentResponse(content.map(value => value.asEditable))
    def content: Option[zio.aws.wisdom.model.ContentData.ReadOnly]
    def getContent
        : ZIO[Any, AwsError, zio.aws.wisdom.model.ContentData.ReadOnly] =
      AwsError.unwrapOptionField("content", content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.CreateContentResponse
  ) extends zio.aws.wisdom.model.CreateContentResponse.ReadOnly {
    override val content: Option[zio.aws.wisdom.model.ContentData.ReadOnly] =
      scala
        .Option(impl.content())
        .map(value => zio.aws.wisdom.model.ContentData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.CreateContentResponse
  ): zio.aws.wisdom.model.CreateContentResponse.ReadOnly = new Wrapper(impl)
}
