package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.{
  ContentType,
  ContentTitle,
  TagValue,
  Arn,
  Uuid,
  Name,
  NonEmptyString,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class ContentSummary(
    contentArn: Arn,
    contentId: Uuid,
    contentType: ContentType,
    knowledgeBaseArn: Arn,
    knowledgeBaseId: Uuid,
    metadata: Map[NonEmptyString, NonEmptyString],
    name: Name,
    revisionId: NonEmptyString,
    status: zio.aws.wisdom.model.ContentStatus,
    tags: Option[Map[TagKey, TagValue]] = None,
    title: ContentTitle
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ContentSummary = {
    import ContentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ContentSummary
      .builder()
      .contentArn(Arn.unwrap(contentArn): java.lang.String)
      .contentId(Uuid.unwrap(contentId): java.lang.String)
      .contentType(ContentType.unwrap(contentType): java.lang.String)
      .knowledgeBaseArn(Arn.unwrap(knowledgeBaseArn): java.lang.String)
      .knowledgeBaseId(Uuid.unwrap(knowledgeBaseId): java.lang.String)
      .metadata(
        metadata
          .map({ case (key, value) =>
            (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .name(Name.unwrap(name): java.lang.String)
      .revisionId(NonEmptyString.unwrap(revisionId): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .title(ContentTitle.unwrap(title): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ContentSummary.ReadOnly =
    zio.aws.wisdom.model.ContentSummary.wrap(buildAwsValue())
}
object ContentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ContentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ContentSummary =
      zio.aws.wisdom.model.ContentSummary(
        contentArn,
        contentId,
        contentType,
        knowledgeBaseArn,
        knowledgeBaseId,
        metadata,
        name,
        revisionId,
        status,
        tags.map(value => value),
        title
      )
    def contentArn: Arn
    def contentId: Uuid
    def contentType: ContentType
    def knowledgeBaseArn: Arn
    def knowledgeBaseId: Uuid
    def metadata: Map[NonEmptyString, NonEmptyString]
    def name: Name
    def revisionId: NonEmptyString
    def status: zio.aws.wisdom.model.ContentStatus
    def tags: Option[Map[TagKey, TagValue]]
    def title: ContentTitle
    def getContentArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(contentArn)
    def getContentId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(contentId)
    def getContentType: ZIO[Any, Nothing, ContentType] =
      ZIO.succeed(contentType)
    def getKnowledgeBaseArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(knowledgeBaseArn)
    def getKnowledgeBaseId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(knowledgeBaseId)
    def getMetadata: ZIO[Any, Nothing, Map[NonEmptyString, NonEmptyString]] =
      ZIO.succeed(metadata)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getRevisionId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(revisionId)
    def getStatus: ZIO[Any, Nothing, zio.aws.wisdom.model.ContentStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTitle: ZIO[Any, Nothing, ContentTitle] = ZIO.succeed(title)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ContentSummary
  ) extends zio.aws.wisdom.model.ContentSummary.ReadOnly {
    override val contentArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.contentArn())
    override val contentId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.contentId())
    override val contentType: ContentType =
      zio.aws.wisdom.model.primitives.ContentType(impl.contentType())
    override val knowledgeBaseArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.knowledgeBaseArn())
    override val knowledgeBaseId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.knowledgeBaseId())
    override val metadata: Map[NonEmptyString, NonEmptyString] = impl
      .metadata()
      .asScala
      .map({ case (key, value) =>
        zio.aws.wisdom.model.primitives.NonEmptyString(
          key
        ) -> zio.aws.wisdom.model.primitives.NonEmptyString(value)
      })
      .toMap
    override val name: Name = zio.aws.wisdom.model.primitives.Name(impl.name())
    override val revisionId: NonEmptyString =
      zio.aws.wisdom.model.primitives.NonEmptyString(impl.revisionId())
    override val status: zio.aws.wisdom.model.ContentStatus =
      zio.aws.wisdom.model.ContentStatus.wrap(impl.status())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val title: ContentTitle =
      zio.aws.wisdom.model.primitives.ContentTitle(impl.title())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ContentSummary
  ): zio.aws.wisdom.model.ContentSummary.ReadOnly = new Wrapper(impl)
}
